/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import net.minecraft.LoginForm;

public class TexturedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image img;
    private Image bgImage;

    public TexturedPanel() {
        this.setOpaque(true);
        try {
            this.bgImage = ImageIO.read(LoginForm.class.getResource("/resourse/tex.png")).getScaledInstance(32, 32, 16);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int w = this.getWidth() / 2 + 1;
        int h = this.getHeight() / 2 + 1;
        if (this.img == null || this.img.getWidth(null) != w || this.img.getHeight(null) != h) {
            this.img = this.createImage(w, h);
            Graphics g = this.img.getGraphics();
            for (int x = 0; x <= w / 32; ++x) {
                for (int y = 0; y <= h / 32; ++y) {
                    g.drawImage(this.bgImage, x * 32, y * 32, null);
                }
            }
            if (g instanceof Graphics2D) {
                Graphics2D gg = (Graphics2D)g;
                int gh = 1;
                gg.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0x20FFFFFF, true), new Point2D.Float(0.0f, gh), new Color(0, true)));
                gg.fillRect(0, 0, w, gh);
                gh = h;
                gg.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0, true), new Point2D.Float(0.0f, gh), new Color(0x60000000, true)));
                gg.fillRect(0, 0, w, gh);
            }
            g.dispose();
        }
        g2.drawImage(this.img, 0, 0, w * 2, h * 2, null);
    }
}

