/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.minecraft.Launcher;
import net.minecraft.LoginForm;
import net.minecraft.Util;

public class LauncherFrame
extends Frame {
    public static final int VERSION = 15;
    private static final long serialVersionUID = 1L;
    public Map<String, String> customParameters = new HashMap<String, String>();
    public Launcher launcher;
    public LoginForm loginForm;

    public LauncherFrame() {
        super("Konungstvo Midgard launcher");
        this.setBackground(Color.BLACK);
        this.loginForm = new LoginForm(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.loginForm, "Center");
        jPanel.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        try {
            this.setIconImage(ImageIO.read(LauncherFrame.class.getResource("/resourse/favicon.png")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        System.out.println("FORCING EXIT!");
                        System.exit(0);
                    }
                }.start();
                if (LauncherFrame.this.launcher != null) {
                    LauncherFrame.this.launcher.stop();
                    LauncherFrame.this.launcher.destroy();
                }
                System.exit(0);
            }
        });
    }

    public void playCached(String string) {
        try {
            if (string == null || string.length() <= 0) {
                string = "Player";
            }
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", string);
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError(exception.toString());
        }
    }

    public void login(String string, String string2, String string3) {
        try {
            String string4 = "user=" + URLEncoder.encode(string, "UTF-8") + "&password=" + URLEncoder.encode(string2, "UTF-8") + "&version=" + 15;
            String string5 = Util.excutePost("http://konungstvo.ru/xauth", string4);
            if (string5 == null) {
                this.showError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u04431!");
                this.loginForm.setNoNetwork();
                return;
            }
            if (!string5.contains(":")) {
                if (string5.trim().equals("Bad login")) {
                    this.showError("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c!");
                } else if (string5.trim().equals("Old version")) {
                    this.loginForm.setOutdated();
                    this.showError("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440!");
                } else {
                    this.showError(string5);
                }
                this.loginForm.setNoNetwork();
                return;
            }
            String[] stringArray = string5.split(":");
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", stringArray[2].trim());
            this.launcher.customParameters.put("latestVersion", stringArray[0].trim());
            this.launcher.customParameters.put("downloadTicket", stringArray[1].trim());
            this.launcher.customParameters.put("sessionId", stringArray[3].trim());
            if (string3.contains(":")) {
                stringArray = string3.split(":");
                this.launcher.customParameters.put("server", stringArray[0]);
                this.launcher.customParameters.put("port", stringArray[1]);
            }
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm.loginOk();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError(exception.toString());
            this.loginForm.setNoNetwork();
        }
    }

    private void showError(String string) {
        this.removeAll();
        this.add(this.loginForm);
        this.loginForm.setError(string);
        this.validate();
    }

    public boolean canPlayOffline(String string) {
        Launcher launcher = new Launcher();
        launcher.customParameters.putAll(this.customParameters);
        launcher.init(string, null, null, null);
        return launcher.canPlayOffline();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        LauncherFrame launcherFrame = new LauncherFrame();
        launcherFrame.setVisible(true);
        launcherFrame.customParameters.put("stand-alone", "true");
        if (stringArray.length >= 3) {
            String string = stringArray[2];
            String string2 = "25565";
            if (string.contains(":")) {
                String[] stringArray2 = string.split(":");
                string = stringArray2[0];
                string2 = stringArray2[1];
            }
            launcherFrame.customParameters.put("server", string);
            launcherFrame.customParameters.put("port", string2);
        }
        if (stringArray.length >= 1) {
            launcherFrame.loginForm.userName.setText(stringArray[0]);
            if (stringArray.length >= 2) {
                launcherFrame.loginForm.password.setText(stringArray[1]);
                launcherFrame.loginForm.doLogin();
            }
        }
    }
}

